﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.IO;

namespace SentTile
{
    class Program
    {
        static void Main(string[] args)
        {
            string url = "http://db3.notify.live.net/throttledthirdparty/01.00/AAH64H" +
                         "M3bkhOQJOI4j32ucHqAgAAAAADAgAAAAQUZm52OjIzOEQ2NDJDRkI5MEVFMEQ";

            string data = "<?xml version=\"1.0\" encoding=\"utf-8\"?>" +
                "<wp:Notification xmlns:wp=\"WPNotification\">" +
                   "<wp:Tile>" +
                        "<wp:BackgroundImage></wp:BackgroundImage>" +
                        "<wp:Count>3</wp:Count>" +
                        "<wp:Title>New Messages</wp:Title>" +
                   "</wp:Tile> " +
                "</wp:Notification>";

            WebRequest request = WebRequest.Create(url);

            request.ContentType = "text/xml";
            request.Method = "POST";
            request.Headers.Add("X-WindowsPhone-Target", "token");
            request.Headers.Add("X-NotificationClass", "1");

            byte[] bytes = Encoding.UTF8.GetBytes(data);

            using (Stream requestStream = request.GetRequestStream())
            {
                requestStream.Write(bytes, 0, bytes.Length);
                try
                {
                    HttpWebResponse response = (HttpWebResponse)request.GetResponse();
                    string notificationStatus = response.Headers["X-NotificationStatus"];
                    string subscriptionStatus = response.Headers["X-SubscriptionStatus"];
                    string connectionStatus = response.Headers["X-DeviceConnectionStatus"];

                    Console.Write(String.Format("X-NotificationStatus:{0}\r\nX-" + 
                        "SubscriptionStatus:{1}\r\nX-DeviceConnectionStatus:{2}",
                        notificationStatus, subscriptionStatus, connectionStatus));
                    Console.ReadKey();
                }
                catch (WebException ex)
                {
                    Console.Write("WebExeption occured with Statuscode:" +
                        ((HttpWebResponse)ex.Response).StatusCode.ToString());
                    Console.ReadKey();
                }
            }
        }
    }
}
